<?php

session_start(); // Tetap harus ada di paling atas

if (isset($_SESSION['client_date'])) {
    // $clientDateString sekarang akan berisi "2025.06.27"
    $clientDateString = $_SESSION['client_date'];
    if ($clientDateString == "") { $clientDateString=date("l.Y.m.d"); }

    // Memecah string tanggalnya (tanpa nama hari)
    list($tahun, $bulan, $tanggal) = explode('.', $clientDateString);

    // Sekarang Anda bisa langsung menggunakan variabel $tahun, $bulan, dan $tanggal
    // untuk logika Anda selanjutnya.
    // Contoh:
    // processConfigForDate($tahun, $bulan, $tanggal);
}

// ==========================================================
// config-loader.php
// ==========================================================
// Tugas file ini adalah menjadi satu-satunya sumber data
// konfigurasi dari PHP untuk JavaScript.
// Sertakan file ini di dalam tag <head> pada semua halaman yang relevan.

// Memastikan file-file penting hanya di-require sekali
require_once 'php-utils.php';
require_once 'conf.php';
$tanggal_efektif = isset($_SESSION['client_date']) ? $_SESSION['client_date'] : null;
if ($tanggal_efektif == "") {$tanggal_efektif=date("l.Y.m.d");}


/**
 * Fungsi untuk membuat jadwal harian lengkap dalam bentuk array.
 * Logika di dalamnya meniru cara kerja waktu.php.
 * @return array Jadwal acara untuk hari ini.
 */
function generateDailyScheduleForJS($tanggal_efektif) {
   #echo "tanggal: $tanggal_efektif\n";
    // Gunakan variabel global yang didefinisikan di conf.php
    global $default1, $default2, $default3, $subuh1, $subuh2, $subuh3;
    global $ashar1, $ashar2, $shuruq1, $shuruq2, $shuruq3, $jumat1, $jumat2;
    global $sched1, $sched2, $sched_load, $jam1, $jam2, $jam3, $jam4, $time_offset;
    $tgl=explode(".",$tanggal_efektif);
    $tagal="$tgl[1].$tgl[2].$tgl[3]";
    $hari=$tgl[0];

    $schedule = [];
    $filePath = 'data/adzan.' . $tagal . '.txt';

    // Jika file adzan tidak ada, kembalikan jadwal kosong
    if (!file_exists($filePath)) {
        error_log("config-loader.php: File adzan tidak ditemukan di $filePath");
        return [];
    }

    $content = file_get_contents($filePath);
    $content = preg_replace('/[\r\n\s]+/', '', trim($content, ';'));
    $adzanList = array_filter(explode(';', $content));
    #$hari = date('l');

    // 1. Tambahkan jadwal sholat ke dalam schedule
    foreach ($adzanList as $entry) {
        $parts = explode('/', $entry);
        if (count($parts) < 2) continue;

        list($name, $time) = $parts;
        $name = trim(ucfirst(strtolower($name)));
        $adzanTime = DateTime::createFromFormat('H:i', trim($time));

        if ($adzanTime === false) continue;

        // Terapkan offset waktu jika ada
        if (isset($time_offset) && $time_offset != 0) {
	    $offset=0;
            $interval = new DateInterval('PT' . abs($offset) . 'S');
            ($time_offset < 0) ? $adzanTime->sub($interval) : $adzanTime->add($interval);
        }

        // Tentukan durasi dari conf.php
        $dur_adzan = $default1; $dur_iqomah = $default2; $dur_sholat = $default3;
        
        if ($name == 'Subuh') { $dur_adzan = $subuh1; $dur_iqomah = $subuh2; $dur_sholat = $subuh3; }
        elseif ($name == 'Ashar') { $dur_adzan += $ashar1; $dur_iqomah += $ashar2; }
        elseif ($name == 'Shuruq') { $dur_adzan = $shuruq1; $dur_iqomah = $shuruq2; $dur_sholat = $shuruq3; }

        // Hitung waktu akhir untuk setiap fase
        $adzanEnd = (clone $adzanTime)->add(new DateInterval("PT{$dur_adzan}M"));
        $iqomahEnd = (clone $adzanTime)->add(new DateInterval("PT{$dur_iqomah}M"));
        $sholatEnd = (clone $adzanTime)->add(new DateInterval("PT{$dur_sholat}M"));

        // Logika khusus untuk sholat Jumat
	#echo "$tanggal_efektif\n$tagal\n";
        if ($hari == 'Friday' && $name == 'Dhuhur') {
            $khotbahEnd = (clone $adzanTime)->add(new DateInterval("PT{$jumat2}M"));
            $schedule[] = ['start' => $adzanTime->format('H:i:s'), 'end' => $adzanEnd->format('H:i:s'), 'mode' => 'adzan', 'prayer' => 'Dhuhur', 'targetPage' => 'adzan-display.php'];
            $schedule[] = ['start' => $adzanEnd->format('H:i:s'), 'end' => $khotbahEnd->format('H:i:s'), 'mode' => 'sholat', 'prayer' => 'Jumat', 'targetPage' => 'blank-screen.php'];
        } else {
            $schedule[] = ['start' => $adzanTime->format('H:i:s'), 'end' => $adzanEnd->format('H:i:s'), 'mode' => 'adzan', 'prayer' => $name, 'targetPage' => 'adzan-display.php'];
            $schedule[] = ['start' => $adzanEnd->format('H:i:s'), 'end' => $iqomahEnd->format('H:i:s'), 'mode' => 'iqomah', 'prayer' => $name, 'targetPage' => 'iqomah-countdown.php'];
            $schedule[] = ['start' => $iqomahEnd->format('H:i:s'), 'end' => $sholatEnd->format('H:i:s'), 'mode' => 'sholat', 'prayer' => $name, 'targetPage' => 'blank-screen.php'];
        }
    }

    // 2. Tambahkan jadwal khusus (sched1, sched2) dari conf.php
    if (!empty($sched1) && !empty($sched2)) {
         $schedule[] = ['start' => $sched1.':00', 'end' => $sched2.':59', 'mode' => 'schedule', 'prayer' => 'Jadwal Khusus', 'targetPage' => $sched_load];
    }
    
    // 3. Tambahkan jadwal idle (blank screen di malam hari)
    $schedule[] = ['start' => $jam3.':00:00', 'end' => '23:59:59', 'mode' => 'blank', 'prayer' => 'Istirahat', 'targetPage' => 'blank-screen.php'];
    $schedule[] = ['start' => sprintf('%02d', $jam1).':00:00', 'end' => sprintf('%02d', $jam2).':00:00', 'mode' => 'blank', 'prayer' => 'Istirahat', 'targetPage' => 'blank-screen.php'];
    $schedule[] = ['start' => '00:00:00', 'end' => sprintf('%02d', $jam4).':00:00', 'mode' => 'blank', 'prayer' => 'Istirahat', 'targetPage' => 'blank-screen.php'];

    // Urutkan jadwal berdasarkan waktu mulai untuk memastikan urutan benar
    usort($schedule, fn($a, $b) => strcmp($a['start'], $b['start']));

    return $schedule;
}

// Ambil semua data yang dibutuhkan oleh JavaScript
$dailySchedule = generateDailyScheduleForJS($tanggal_efektif);
$prayerTimes = MasjidDisplayUtils::getTodayPrayerTimes();
$runningTextArray = isset($runningTextArray) ? $runningTextArray : [];
$nasihatList = isset($nasihatList) ? $nasihatList : []; // <-- TAMBAHKAN BARIS INI

// Cetak semua data sebagai blok <script> JavaScript
echo '<script id="php-data-injection">';

// Jadwal harian untuk mode-switcher
echo 'const dailySchedule = ' . json_encode($dailySchedule) . ';';

// Waktu sholat untuk sidebar dan countdown
echo 'const prayerTimes = ' . json_encode($prayerTimes) . ';';

// Teks berjalan untuk footer
echo 'const runningTextArray = ' . json_encode($runningTextArray) . ';';
echo 'const nasihatList = ' . json_encode($nasihatList) . ';'; // <-- TAMBAHKAN BARIS INI

// Konfigurasi umum lainnya
echo 'const config = {';
    echo 'tvId: "' . (isset($_GET['tv']) ? preg_replace('/[^a-zA-Z0-9\-]/', '', $_GET['tv']) : 'unknown') . '",';
    echo 'slideshowInterval: ' . ($slideshow_duration ?? 30) . ',';
    echo 'youtubeIntervalMinutes: ' . ($youtube_interval_minutes ?? 3) . ',';
    echo 'displayMode: "' . ($display_mode ?? 'normal') . '",';
    echo 'timeOffset: '.$time_offset.',';
    echo 'updateHighlightInterval: ' . (isset($updateHighlight) ? $updateHighlight * 1000 : 60000);
echo '};';



echo '</script>';
?>
