<?php
session_start(); // HARUS di baris paling atas

// Main Interface PHP - Integrated dengan waktu.php dan server failover
// ================================================

require_once 'php-utils.php';
require_once 'conf.php';
require_once 'image-loader.php';
require_once 'config-loader.php';
require_once 'cache-manager.php';

// Dapatkan ID TV dari query string untuk membedakan Smart TV
$tv_id = isset($_GET['tv']) ? preg_replace('/[^a-zA-Z0-9\-]/', '', $_GET['tv']) : 'unknown';
$client_ip = $_SERVER['REMOTE_ADDR'];
//error_log("Main.php accessed: IP=$client_ip, TV=$tv_id, Time=" . date('H:i:s'));

// Function to check and update adzan data if needed

// Check status and redirect if necessary
#MasjidDisplayUtils::redirectToCorrectPage('main.php');

// Get current status
$tanggal_efektif = isset($_SESSION['client_date']) ? $_SESSION['client_date'] : null;

$currentStatus = MasjidDisplayUtils::getCurrentStatus();
$parsedStatus = MasjidDisplayUtils::parseStatus($currentStatus);
$hijriDate = getHijriDate($tanggal_efektif); // getHijriDate perlu dimodifikasi
//$hijriDate = getHijriDate();

// Get prayer times
//$prayerTimes = MasjidDisplayUtils::getTodayPrayerTimes();
$prayerTimes = MasjidDisplayUtils::getTodayPrayerTimes($tanggal_efektif); // Fungsi ini juga


// --- KONFIGURASI BARU UNTUK VIDEO STREAM ---
$youtube_video_id = ''; // Tidak digunakan karena diganti kabah_clip.mp4
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($masjid_name, ENT_QUOTES, 'UTF-8'); ?> - Tampilan Digital</title>
    
    <link rel="stylesheet" href="css/main.css">
    <link rel="stylesheet" href="css/transitions.css">
    <link rel="stylesheet" href="css/overlay-layers.css">
    
    <meta name="description" content="Tampilan Digital <?php echo htmlspecialchars($masjid_name, ENT_QUOTES, 'UTF-8'); ?> - Jadwal Sholat dan Informasi Masjid">
    <meta name="keywords" content="masjidid, jadwal sholat, Masjid Miftahul Jannah, waktu sholat">
    <meta name="author" content="<?php echo htmlspecialchars($masjid_name, ENT_QUOTES, 'UTF-8'); ?>">
    <style>
        .slideshow-container__image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
        }
    </style>


</head>
<body>
    <div class="main-container">
        <div class="prayer-sidebar">
            <div class="masjid-info">
                <div class="masjid-name"><?php echo htmlspecialchars($masjid_name, ENT_QUOTES, 'UTF-8'); ?></div>
            </div>
            <div class="prayer-times-section">
                <div class="prayer-list">
                    <?php if ($prayerTimes): ?>
                        <?php foreach ($prayerTimes as $prayerName => $prayerTime): ?>
                            <?php if (strtolower($prayerName) !== 'syuruq'): ?>
                                <div class="prayer-item" data-prayer="<?php echo htmlspecialchars(strtolower($prayerName), ENT_QUOTES, 'UTF-8'); ?>">
                                    <div class="prayer-name"><?php echo (date("N") == 5 && strtolower($prayerName) == "dhuhur") ? "Jumatan" : htmlspecialchars(ucfirst($prayerName), ENT_QUOTES, "UTF-8"); ?></div>
                                    <div class="prayer-time"><?php echo htmlspecialchars($prayerTime, ENT_QUOTES, 'UTF-8'); ?></div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="prayer-item">
                            <div class="prayer-name">Jadwal Sholat Tidak Tersedia</div>
                            <div class="prayer-time">--:--</div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="countdown-section">
            </div>
        </div>

        <div class="main-content">
            <div class="header">
                <div class="clock-section">
                    <div class="digital-clock" id="digitalClock"><?php echo date('H:i')."<font style=\"font-size:20%\">".date(':s'); ?></font></div>
                    <div class="date-info">
                        <div class="current-date" id="currentDate"><?php echo htmlspecialchars(MasjidDisplayUtils::getIndonesianDate(), ENT_QUOTES, 'UTF-8'); ?></div>
                        <div class="hijri-date" id="hijriDate"><?php echo htmlspecialchars($hijriDate, ENT_QUOTES, 'UTF-8'); ?></div>
                    </div>
                </div>
            </div>
            <div class="content-area">
                <div class="slideshow-container" id="slideshowContainer">
                    </div>
            </div>
            <div class="countdown-section">
                <div class="countdown-container">
                    <div class="countdown-label" id="nextPrayerLabel">Sholat</div>
                    <div class="countdown-time" id="countdown">---:--:--</div>
                    <div class="next-prayer-info" id="nextPrayerInfo"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="running-text-container">
        <div class="running-text" id="runningText"></div><span id="currentTime"></span>
    </div>
    <script>
        function refreshAtNewHour() {
            const now = new Date();
            const minutes = now.getMinutes();
            const seconds = now.getSeconds();

            // Memperbarui tampilan waktu saat ini
            document.getElementById('currentTime').textContent = now.toLocaleTimeString();
            //console.log("Cek: " + now);

            // Jika menit adalah 0 dan detik adalah 0, refresh halaman
            if (minutes === 0 && seconds === 0) {
                console.log("Refresh Main Per Jam");
                window.location.href="main.php";
            }
        }

        // Jalankan fungsi setiap detik untuk memeriksa waktu
        // setInterval(refreshAtNewHour, 1000); // DISABLED - causing refresh issues // 1000 milidetik = 1 detik
        // refreshAtNewHour(); // DISABLED
    </script>


    <!-- Countdown Overlay -->
    <div class="countdown-overlay" id="countdownOverlay">
        <div class="countdown-circle-container">
            <canvas id="countdownCircleCanvas" class="countdown-circle-canvas"></canvas>
            <div id="countdownOverlayText" class="countdown-overlay-text"></div>
        </div>
    </div>

    <div class="tabir" style="display:none;" id="tabir">
	<font id="loading">Loading content..</font>
    </div>

<?php echo file_get_contents("/mmj/ringan/early_countdown_script.js"); ?>
    <script src="slideshow.js?<?php echo rand(1,99999999999); ?>"></script>
    <script src="view-slideshow.js?<?php echo rand(1,99999999999); ?>"></script>
    <script src="adzan-layer.js?<?php echo rand(1,99999999999); ?>"></script>
    <script src="iqomah-layer.js?<?php echo rand(1,99999999999); ?>"></script>
    <script src="main.js?<?php echo rand(1,99999999999); ?>"></script>


    <script>
    // Register Service Worker untuk offline support
    if ("serviceWorker" in navigator) {
        window.addEventListener("load", () => {
            navigator.serviceWorker.register("sw-enhanced.js")
                .then(registration => {
                    console.log("SW registered:", registration);
                    // Check for updates every 10 minutes
                    setInterval(() => {
                        registration.update();
                    }, 600000);
                })
                .catch(error => {
                    console.error("SW registration failed:", error);
                });
        });
    }
    </script>

    <!-- Overlay Layers for Unified System -->
    <!-- Adzan Display Overlay -->
    <div class="overlay-layer" id="adzanOverlay" style="display: none;">
        <div class="bg-decoration"></div>
        <div class="adzan-container">
            <div class="adzan-title" id="adzanTitle">Saatnya Adzan</div>
            <div class="prayer-name" id="prayerName">Memuat...</div>
            <div class="arabic-message" id="arabicMessage">حَيَّ عَلَى الصَّلاةِ</div>
            <div class="indonesian-message" id="indonesianMessage"></div>
        </div>
        <div class="progress-container">
            <div class="progress-bar" id="progressBar"></div>
        </div>
        <div class="progress-text" id="progressText">--:--</div>
    </div>

    <!-- Iqomah Countdown Overlay -->
    <div class="overlay-layer" id="iqomahOverlay" style="display: none;">
        <div class="bg-decoration">
            <div class="decoration-pattern"></div>
            <div class="decoration-pattern"></div>
            <div class="decoration-pattern"></div>
        </div>
        <div class="iqomah-container">
            <div class="iqomah-title">Menuju Iqomah</div>
            <div class="prayer-info" id="prayerInfo">Memuat...</div>
            <div class="countdown-capsule" id="countdownCapsule">
                <div class="countdown-time" id="countdownTime">--:--</div>
            </div>
            <div class="nasihat-container">
                <div class="nasihat-content" id="nasihatContent">
                    <div class="nasihat-item active" id="nasihatItem"><?php echo isset($nasihatList) && !empty($nasihatList) ? htmlspecialchars($nasihatList[array_rand($nasihatList)], ENT_QUOTES, 'UTF-8') : 'Matikan atau silent handphone Anda'; ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Blank/Sholat Screen Overlay -->
    <div class="overlay-layer" id="blankOverlay" style="display: none;">
        <div class="corner-decoration"></div>
        <div class="corner-decoration"></div>
        <div id="sholatInfoContainer"></div>
        <div class="clock-container">
            <div class="clock-time" id="clockTime">--:--:--</div>
            <div class="clock-date" id="clockDate">Memuat tanggal...</div>
        </div>
        <div class="progress-indicator">
            <div class="progress-dots" id="progressDots"></div>
            <div class="progress-text" id="blankProgressText">--:--</div>
        </div>
    </div>

</body>
</html>

// test perubahan Kam 31 Jul 2025 11:11:59  WIB
