<?php
/**
 * Endpoint untuk memeriksa timestamp perubahan file
 * Diakses oleh jQuery untuk menentukan kapan harus refresh iframe
 */

header('Content-Type: application/json');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

$timestamp_file = __DIR__ . '/data/last_change.json';
$response = array(
    'success' => false,
    'timestamp' => 0,
    'readable_time' => '',
    'error' => ''
);

try {
    if (file_exists($timestamp_file)) {
        $data = json_decode(file_get_contents($timestamp_file), true);
        
        if (json_last_error() === JSON_ERROR_NONE && isset($data['last_change'])) {
            $response['success'] = true;
            $response['timestamp'] = (int)$data['last_change'];
            $response['readable_time'] = $data['last_change_readable'] ?? '';
            $response['status'] = $data['status'] ?? 'unknown';
        } else {
            $response['error'] = 'Invalid JSON format';
        }
    } else {
        // File belum ada, buat timestamp default
        $response['success'] = true;
        $response['timestamp'] = time();
        $response['readable_time'] = date('c');
        $response['status'] = 'initial';
    }
} catch (Exception $e) {
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
?>
