// Redirect cooldown - prevent excessive redirects
let lastRedirectTime = 0;
const REDIRECT_COOLDOWN = 5000; // 5 seconds
// main.js - Versi Final dengan 4 Web Worker
//
const countdownOverlay = document.getElementById('countdownOverlay');
const tabir = document.getElementById('tabir');
const countdownOverlayText = document.getElementById('countdownOverlayText');
const countdownCircleCanvas = document.getElementById('countdownCircleCanvas');
const ctx = countdownCircleCanvas.getContext('2d');
let countdownOverlayVisible = false; // <<< VARIABEL INI DIDEKLARASIKAN

// Referensi global untuk workers, agar bisa di-terminate jika diperlukan
let clockWorker;
let countdownWorker;
let prayerWorker;
let slideWorker;

function drawProgressBar(percentage) {
    const size = countdownCircleCanvas.width;
    const radius = size / 2 - 10; // Kurangi sedikit untuk padding
    const centerX = size / 2;
    const centerY = size / 2;
    const startAngle = -Math.PI / 2; // Mulai dari atas
    const endAngle = startAngle + (Math.PI * 2 * (percentage / 100));

    ctx.clearRect(0, 0, size, size); // Bersihkan canvas

    // Gambar latar belakang lingkaran (garis putus-putus)
    ctx.beginPath();
    ctx.arc(centerX, centerY, radius, 0, Math.PI * 2);
    ctx.lineWidth = 10; // Lebar garis
    ctx.strokeStyle = 'rgba(255, 255, 255, 0.2)'; // Warna abu-abu transparan
    ctx.setLineDash([5, 5]); // Garis putus-putus
    ctx.stroke();

    // Gambar progress bar
    ctx.beginPath();
    ctx.arc(centerX, centerY, radius, startAngle, endAngle);
    ctx.lineWidth = 10;
    ctx.lineCap = 'round'; // Ujung garis membulat
    ctx.setLineDash([]); // Hapus garis putus-putus

    // Gradient warna untuk progress bar
    const gradient = ctx.createLinearGradient(0, 0, size, size);
    gradient.addColorStop(0, '#f59e0b'); // Orange
    gradient.addColorStop(1, '#ef4444'); // Red
    ctx.strokeStyle = gradient;
    ctx.stroke();
}

function initializeCountdownCanvas() {
    const container = countdownCircleCanvas.parentElement;
    const size = Math.min(container.offsetWidth, container.offsetHeight);
    countdownCircleCanvas.width = size;
    countdownCircleCanvas.height = size;
    // Redraw immediately to ensure it's visible if already active
    if (countdownOverlayVisible) {
        drawProgressBar(0); // Draw initial empty circle
    }
}


function checkAndSwitchMode() {
    if (!Array.isArray(dailySchedule)) return;
    const clockOffset = config?.timeOffset ? config.timeOffset * 1000 : 0;
    const now = new Date(Date.now() + clockOffset);
    const currentTime = now.toTimeString().slice(0, 8);
    const currentPage = window.location.pathname.split('/').pop() || 'index.php';

    let activeEvent = null;
    for (const event of dailySchedule) {
        if (currentTime >= event.start && currentTime < event.end) {
            activeEvent = event;
            break;
        }
    }

    function getTodayFilename() {
      const today = new Date();
      const yyyy = today.getFullYear();
      const mm = String(today.getMonth() + 1).padStart(2, '0');
      const dd = String(today.getDate()).padStart(2, '0');
      //return `${yyyy}.${mm}.${dd}.html`;
      return 'main.php';

    }

    //let targetPage = 'main.' + getTodayFilename(); // Default ke halaman utama
    let targetPage = getTodayFilename(); // Default ke halaman utama
    if (activeEvent) {
        targetPage = activeEvent.targetPage;
    } else {
        // Jika tidak ada event terjadwal, periksa display mode override
        if (typeof config !== 'undefined' && config.displayMode !== 'normal') {
            switch (config.displayMode) {
                case 'streaming': targetPage = 'stream' + getTodayFilename(); break;
                case 'kamera': targetPage = 'kamera' + getTodayFilename(); break;
                case 'black': targetPage = 'blank-screen' + getTodayFilename(); break;
            }
        }
    }

	
   console.log("DEBUG:", currentTime, "currentPage:", currentPage, "targetPage:", targetPage);

    if (currentPage !== targetPage && window.location.href.endsWith(targetPage) === false) {
        console.log(`REDIRECT: Pindah dari ${currentPage} ke ${targetPage} / ${config.displayMode}`);
        lastRedirectTime = Date.now();
        
        // --- START: Penambahan kode untuk membebaskan memori sebelum redirect ---
        // 1. Terminate semua Web Worker yang aktif
        // Ini adalah langkah penting untuk memastikan worker tidak terus berjalan setelah halaman berpindah
        if (clockWorker) {
            clockWorker.terminate();
            console.log("clockWorker terminated.");
        }
        if (countdownWorker) {
            countdownWorker.terminate();
            console.log("countdownWorker terminated.");
        }
        if (prayerWorker) {
            prayerWorker.terminate();
            console.log("prayerWorker terminated.");
        }
        if (slideWorker) {
            slideWorker.terminate();
            console.log("slideWorker terminated.");
        }
        
        // 2. Bersihkan konten DOM utama (asumsi ada container utama dengan id 'slideshowContainer')
        // Menghapus elemen dari DOM membantu garbage collector, terutama jika ada banyak gambar atau elemen dinamis.
        const mainContentElement = document.getElementById('slideshowContainer');
        if (mainContentElement) {
            mainContentElement.innerHTML = ''; // Hapus semua children dari container
            console.log("DOM content cleared before redirect.");
        }

        // 3. Melepaskan referensi global ke objek besar
        // Ini adalah langkah opsional dan efeknya mungkin tidak langsung terlihat,
        // tetapi membantu GC dengan menghapus referensi eksplisit yang mungkin mencegah objek diklaim.
        // Contoh variabel global yang mungkin Anda ingin set ke null:
        // slideshowManifest = null;
        // prayerTimes = null;
        // config = null;
        // dailySchedule = null;
        // runningTextArray = null;
        // ctx = null; // Konteks Canvas
        // Anda bisa menambahkan lebih banyak sesuai variabel global Anda yang mungkin menyimpan data besar.
        
        // --- END: Penambahan kode untuk membebaskan memori sebelum redirect ---

        window.location.href = targetPage;
	console.log(now + " / targetPage:" + targetPage);
    }
}

function initializeMainDisplay() {
    const clockOffset = (config?.timeOffset || 0) * 1000;
    console.log('🚀 Inisialisasi Tampilan Utama dengan 4 Worker');

    // --- INISIALISASI SEMUA WORKER ---

    // 1. Clock Worker (Sekarang menjadi Pemicu Utama)
    clockWorker = new Worker('clock.js'); // Deklarasikan di luar agar bisa diakses global
    clockWorker.postMessage({ clockOffset });
    clockWorker.onmessage = (e) => {
        const clockElement = document.getElementById('digitalClock');
        if (clockElement && e.data.time) {
            clockElement.innerHTML = e.data.time;

            // SAAT DETIK KE-0, LAKUKAN SEMUA TUGAS PER MENIT
            if (e.data.second === 0) {
                console.log("Detik ke-0 terdeteksi. Memicu update per menit.");
                // Log penggunaan memori pada setiap pergantian menit (opsional, untuk debugging)
                console.log(`Memory used: ${performance.memory?.usedJSHeapSize / 1024 / 1024 || 'unknown'} MB`);

                updateDateInfo();    // Update tanggal
                manageVideoStream(); // Periksa apakah waktunya video

                // ==========================================================
                // === PERUBAHAN INTI ADA DI SINI ===
                // Kirim pesan ke slide.js untuk meminta URL gambar baru
                slideWorker.postMessage('get');
                // ==========================================================

                // --- START: Penambahan kode untuk memicu refresh halaman setiap jam penuh ---
                // Ini akan membebaskan memori secara total setiap jam (menit 0, detik 0)
                const now = new Date(Date.now() + clockOffset);
                const minutes = now.getMinutes();
                const seconds = now.getSeconds();

                if (minutes === 0 && seconds === 0) {
                    console.log("Waktu menunjukkan awal jam (00:00). Melakukan refresh halaman untuk pembersihan memori.");
                    // Opsional: terminate worker di sini juga jika refresh_main.php tidak bisa diandalkan
                    // if (clockWorker) clockWorker.terminate();
                    // if (countdownWorker) countdownWorker.terminate();
                    // if (prayerWorker) prayerWorker.terminate();
                    // if (slideWorker) slideWorker.terminate();
                    // location.reload(); // DISABLED for Android TV // Ini adalah mekanisme pembersihan paling efektif
                }
                // --- END: Penambahan kode untuk memicu refresh halaman setiap jam penuh ---
            }
        }
    };

    // 2. Countdown Worker
    countdownWorker = new Worker('countdown.js'); // Deklarasikan di luar
    countdownWorker.postMessage({ prayerTimes, clockOffset, prayerOrder: ['subuh', 'shuruq', 'dhuhur', 'ashar', 'maghrib', 'isya'] });
    countdownWorker.onmessage = (e) => {

        if (e.data) {
            // Menggunakan variabel yang sudah dideklarasikan di bawah
            const countdownElement = document.getElementById('countdown');
            const labelElement = document.getElementById('nextPrayerLabel');
            const nextPrayerInfoElement = document.getElementById('nextPrayerInfo'); // Asumsi ada elemen ini

            if (countdownElement && e.data.countdown) {
                countdownElement.textContent = e.data.countdown;
            }
            if (labelElement && e.data.label) {
                labelElement.textContent = e.data.label.split(' ')[0]; // Hanya nama sholat
            }
            if (nextPrayerInfoElement && e.data.label) {
                //nextPrayerInfoElement.textContent = e.data.label.includes('(Besok)') ? 'Besok' : '';
		let test = 'test'; // Variabel test ini saya biarkan sesuai aslinya
            }

            // Extract remaining seconds for overlay logic
            const countdownParts = e.data.countdown.split(':');
            let totalSeconds = 0;
            if (countdownParts.length === 3) {
                const hours = parseInt(countdownParts[0].replace('-', ''));
                const minutes = parseInt(countdownParts[1]);
                const seconds = parseInt(countdownParts[2]);
                totalSeconds = hours * 3600 + minutes * 60 + seconds;
            } else if (countdownParts.length === 2) { // Fallback for MM:SS
                const minutes = parseInt(countdownParts[0].replace('-', ''));
                const seconds = parseInt(countdownParts[1]);
                totalSeconds = minutes * 60 + seconds;
            }

            // Countdown Overlay Logic
            // --- BLOK KODE INI TIDAK LAGI DUPLIKAT ---
            if (totalSeconds <= 60 && totalSeconds >= 0) {
                if (!countdownOverlayVisible) {
                    countdownOverlay.classList.add('show');
                    countdownOverlayVisible = true;
                    initializeCountdownCanvas(); // Initialize canvas size when shown
                }
                countdownOverlayText.textContent = totalSeconds.toString();
                // Calculate percentage for progress bar (60 seconds = 0%, 0 seconds = 100%)
                const percentage = ((60 - totalSeconds) / 60) * 100;
                drawProgressBar(percentage);
            } else {
                if (countdownOverlayVisible) {
                    countdownOverlay.classList.remove('show');
                    countdownOverlayVisible = false;
                }
            }

            // Redirect to adzan-display.php when countdown reaches 0
            if (totalSeconds === 0) {
                if (countdownOverlayVisible) { // Pastikan overlay disembunyikan sebelum redirect
                    countdownOverlay.classList.remove('show');
                    countdownOverlayVisible = false;
                }
                
                // --- START: Penambahan kode untuk membebaskan memori sebelum redirect ---
                // 1. Terminate semua Web Worker yang aktif
                if (clockWorker) {
                    clockWorker.terminate();
                    console.log("clockWorker terminated (totalSeconds === 0).");
                }
                if (countdownWorker) {
                    countdownWorker.terminate();
                    console.log("countdownWorker terminated (totalSeconds === 0).");
                }
                if (prayerWorker) {
                    prayerWorker.terminate();
                    console.log("prayerWorker terminated (totalSeconds === 0).");
                }
                if (slideWorker) {
                    slideWorker.terminate();
                    console.log("slideWorker terminated (totalSeconds === 0).");
                }
                
                // 2. Bersihkan konten DOM utama
                const mainContentElement = document.getElementById('slideshowContainer');
                if (mainContentElement) {
                    mainContentElement.innerHTML = ''; 
                    console.log("DOM content cleared before redirect (totalSeconds === 0).");
                }
                // --- END: Penambahan kode untuk membebaskan memori sebelum redirect ---

                window.location.href = 'adzan-display.php';
            }

	tabir.style.display = "none"; console.log("Loading screen permanently hidden"); // Variabel tabir ini saya biarkan sesuai aslinya
        }
    };

    // 3. Prayer Highlight Worker
    prayerWorker = new Worker('prayer.js'); // Deklarasikan di luar
    prayerWorker.postMessage({ dailySchedule, prayerTimes, clockOffset });
    prayerWorker.onmessage = (e) => {
        updatePrayerHighlight(e.data.current, e.data.next);
    };

    // 4. Slideshow Worker (Sekarang Pasif)
    slideWorker = new Worker('slide.js'); // Deklarasikan di luar
    slideWorker.postMessage({ manifest: slideshowManifest, prayerTimes, config, clockOffset });
    slideWorker.onmessage = (e) => {
        const imageUrl = e.data;
        showImageSlide(imageUrl); // Terima URL dan tampilkan
    };

    // --- FUNGSI-FUNGSI MANIPULASI DOM (Sekarang lebih sederhana) ---

    function updateDateInfo() {
        const dateElement = document.getElementById('currentDate');
        if (!dateElement) return;
        const now = new Date(Date.now() + clockOffset);
        const days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
        const months = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
        dateElement.textContent = `${days[now.getDay()]}, ${now.getDate()} ${months[now.getMonth()]} ${now.getFullYear()}`;
    }

    function updatePrayerHighlight(currentPrayer, nextPrayer) {
        document.querySelectorAll('.prayer-item').forEach(item => {
            item.classList.remove('current-prayer', 'next-prayer');
        });

        if (currentPrayer) {
            const currentElement = document.querySelector(`[data-prayer="${currentPrayer}" i]`);
            if (currentElement) currentElement.classList.add('current-prayer');
        }
        if (nextPrayer) {
            const nextElement = document.querySelector(`[data-prayer="${nextPrayer}" i]`);
            if (nextElement) nextElement.classList.add('next-prayer');
        }
    }

    function initRunningText() {
        const container = document.getElementById('runningText');
        if (!container || !runningTextArray?.length) return;
        const shuffledText = [...runningTextArray].sort(() => Math.random() - 0.5).slice(0, 5);
        const separator = '   •   ';
        container.innerHTML = `<div class="running-text-wrapper"><span>${shuffledText.join(separator) + separator}</span><span>${shuffledText.join(separator) + separator}</span></div>`;
    }

    const slideshowContainer = document.getElementById('slideshowContainer');
    let isShowingVideo = false;

    function showImageSlide(imageUrl) {
        if (!slideshowContainer || isShowingVideo) return;
        slideshowContainer.innerHTML = `<img src="${imageUrl}" class="slideshow-container__image" alt="Slideshow Image">`;
    }

    function showVideoStream() {
        if (!slideshowContainer) return;
        slideshowContainer.innerHTML = `<video src="slideshow/kabah.mp4" style="width:100%;height:100%;object-fit:cover;" autoplay muted loop playsinline></video>`;
    }

    function manageVideoStream() {
        const now = new Date(Date.now() + clockOffset);
        const shouldShowVideo = now.getMinutes() % (config?.youtubeIntervalMinutes || 10) === 0;

        if (shouldShowVideo && !isShowingVideo) {
            isShowingVideo = true;
            showVideoStream();
        } else if (!shouldShowVideo && isShowingVideo) {
            isShowingVideo = false;
            // Biarkan slide worker yang akan mengganti gambar secara otomatis pada interval berikutnya
        }
    }


    // --- INISIALISASI TAMPILAN AWAL ---
    updateDateInfo();
    initRunningText();
    window.addEventListener('resize', initializeCountdownCanvas);
    initializeCountdownCanvas(); // Initial call
    manageVideoStream();
    console.log(`Memory used: ${performance.memory?.usedJSHeapSize / 1024 / 1024 || 'unknown'} MB`);

    const prayerListContainer = document.querySelector('.prayer-list');
    if (prayerListContainer && prayerTimes) {
        prayerListContainer.innerHTML = Object.entries(prayerTimes)
            .filter(([name]) => name.toLowerCase() !== 'jumat') // Filter shuruq
            .map(([name, time]) => `<div class="prayer-item" data-prayer="${name}"><div class="prayer-name">${name}</div><div class="prayer-time">${time}</div></div>`)
            .join('');
    }
}

// ========================================================================
// --- TITIK MASUK EKSEKUSI SCRIPT ---
// ========================================================================
document.addEventListener("DOMContentLoaded", () => {
    // Hide loading screen immediately
    const tabir = document.getElementById("tabir");
    const loading = document.getElementById("loading");
    if (tabir) tabir.style.display = "none";
    if (loading) loading.style.display = "none";
    console.log("Loading screen hidden on DOM ready");

    // Fungsi sinkronisasi tanggal client ke server (tidak perlu diubah)
    function sendClientDateToServer() {
        const now = new Date();
        const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        const formattedDate = `${days[now.getDay()]}.${now.getFullYear()}.${String(now.getMonth() + 1).padStart(2, '0')}.${String(now.getDate()).padStart(2, '0')}`;
        
        fetch('date-sync.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: 'client_date=' + encodeURIComponent(formattedDate)
        }).then(r => r.json()).then(d => {
            console.log('Server Response:', d.message, 'Date Sent:', d.received_date);
            sessionStorage.setItem('clientDateSynched', 'true');
        }).catch(e => console.error('Error sending client date:', e));
    }

    if (!sessionStorage.getItem('clientDateSynched')) {
        sendClientDateToServer();
    }

    // Interval utama untuk checkAndSwitchMode (tetap setiap detik)
    setInterval(checkAndSwitchMode, 10000); // Changed to 10 seconds // Re-enabled with fix
    
    if (document.getElementById('slideshowContainer')) {
	checkAndSwitchMode(); // Re-enabled with fix
        initializeMainDisplay();
	//tabir.style.display = "none"; console.log("Loading screen permanently hidden");
    }
});
