// slide.js - Versi Perbaikan (Pasif, tanpa setInterval)

let slideshowManifest, prayerTimes, config, clockOffset;
let isInitialized = false;

// Fungsi ini tidak berubah, tetap bertugas menghitung URL
function getCurrentImageUrl() {
    if (!slideshowManifest || Object.keys(slideshowManifest).length === 0) {
        return `slideshow/fallback.jpg`;
    }

    const now = new Date(Date.now() + clockOffset);
    const dayNames = ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"];
    const currentDay = dayNames[now.getDay()];
    const currentTime = `${String(now.getHours()).padStart(2, '0')}:${String(now.getMinutes()).padStart(2, '0')}`;

    const isyaKey = Object.keys(prayerTimes).find(k => k.toLowerCase() === 'isya');
    const maghribKey = Object.keys(prayerTimes).find(k => k.toLowerCase() === 'ashar');
    const showJumatImages = (currentDay === 'thursday' && isyaKey && currentTime >= prayerTimes[isyaKey]) ||
                            (currentDay === 'friday' && maghribKey && currentTime < prayerTimes[maghribKey]);

    let availableGroups = {};
    if (showJumatImages && slideshowManifest['jumat'] && slideshowManifest['jumat'].length > 0) {
        availableGroups['jumat'] = slideshowManifest['jumat'];
    } else {
        for (const group in slideshowManifest) {
            if (group.toLowerCase() !== 'jumat') {
                availableGroups[group] = slideshowManifest[group];
            }
        }
    }

    if (Object.keys(availableGroups).length === 0) {
        return `slideshow/fallback.jpg`;
    }

    const alignedTime = Math.floor((Date.now() + clockOffset) / 1000 / (config.slideshowInterval || 60));
    const groupNames = Object.keys(availableGroups).sort();
    const selectedGroupName = groupNames[alignedTime % groupNames.length];
    const filesInGroup = availableGroups[selectedGroupName].sort();

    if (!filesInGroup || filesInGroup.length === 0) {
        return `slideshow/fallback.jpg`;
    }

    const selectedFile = filesInGroup[alignedTime % filesInGroup.length];
    return `slideshow/${selectedFile}`;
}


// onmessage sekarang menangani 2 jenis pesan: inisialisasi dan permintaan update
onmessage = (e) => {
    // Pesan untuk inisialisasi data (hanya sekali)
    if (e.data.manifest) {
        slideshowManifest = e.data.manifest;
        prayerTimes = e.data.prayerTimes;
        config = e.data.config;
        clockOffset = e.data.clockOffset;
        isInitialized = true;
        
        // Langsung kirim gambar pertama saat worker siap
        const firstImageUrl = getCurrentImageUrl();
        postMessage(firstImageUrl);
        return;
    }
    
    // Pesan untuk meminta update gambar (setiap menit dari main.js)
    if (e.data === 'get' && isInitialized) {
        const imageUrl = getCurrentImageUrl();
        postMessage(imageUrl);
    }
};
